#include <iostream>
using namespace std;

// Funkcija za racunanje ukupne lepote matrice
int calculateBeauty(int N, int M, int K, int L, int A[]) {
    int matrix[N][M];

    // Popunjavanje matrice elementima iz niza A
    int index = 0;
    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            matrix[i][j] = A[index++];
        }
    }

    // Racunanje ukupne lepote matrice
    int maxBeauty = 0;
    for (int i = 0; i <= N - K; ++i) {
        for (int j = 0; j <= M - L; ++j) {
            int currentBeauty = 0;
            // Izracunavanje sume podmatrice dimenzija K × L
            for (int x = i; x < i + K; ++x) {
                for (int y = j; y < j + L; ++y) {
                    currentBeauty += matrix[x][y];
                }
            }
            // Ažuriranje maksimalne lepote
            maxBeauty = max(maxBeauty, currentBeauty);
        }
    }

    return maxBeauty;
}

int main() {
    int N, M, K, L;
    cin >> N >> M >> K >> L;

    int elements[N * M];
    for (int i = 0; i < N * M; ++i) {
        cin >> elements[i];
    }

    // Pozivanje funkcije za racunanje lepote matrice
    int result = calculateBeauty(N, M, K, L, elements);
    cout << result << endl;

    return 0;
}